#ifndef _2INCH9_EPD_H_
#define _2INCH9_EPD_H_

#include "sys.h"

#define EPD_WIDTH   168
#define EPD_HEIGHT  384
#define EPD_ARRAY  EPD_WIDTH*EPD_HEIGHT/4


#define SOURCE_BITS     168
#define GATE_BITS   384
#define ALLSCREEN_BYTES  16128 


#define	EPD_W21_CS      PBout(12)
#define	EPD_W21_DC      PAout(8)
#define	EPD_W21_RST     PAout(11)
#define	isEPD_W21_BUSY  PAin(12)

#define EPD_W21_MOSI	  PBout(15)

#define EPD_W21_CLK	    PBout(13)



#define G_BLACK   0x00  /// 00
#define G_WHITE   0x01  /// 01
#define YELLOW  0x02  /// 10
#define RED     0x03  /// 11

// Color
#define  EPD_2IN9G_BLACK   0x0
#define  EPD_2IN9G_WHITE   0x1
#define  EPD_2IN9G_YELLOW  0x2
#define  EPD_2IN9G_RED     0x3

void delay_xms(unsigned int xms);
void EPD_GPIO_Init(void);
void SPI_Write(unsigned char value);
void EPD_W21_WriteDATA(unsigned char datas);
void EPD_W21_WriteCMD(unsigned char command);
//Full screen refresh display
void EPD_HW_Init(void); 
void EPD_WhiteScreen_White(void);
void EPD_WhiteScreen_Black(void);
void EPD_WhiteScreen_Red(void);
void EPD_WhiteScreen_Yellow(void);
void EPD_DeepSleep(void);
//Partial refresh display
void PIC_display(const unsigned char* picData);
void GUI_display(const unsigned char* picData);
#endif
/***********************************************************
						end file
***********************************************************/


